/*
 * Decompiled with CFR 0.152.
 */
package jace.config;

import jace.apple2e.Apple2e;
import jace.config.BooleanComponent;
import jace.config.ConfigurableField;
import jace.config.Configuration;
import jace.config.DynamicSelectComponent;
import jace.config.FileComponent;
import jace.config.ISelection;
import jace.config.IntegerComponent;
import jace.config.StringComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class ConfigurationPanel
extends JPanel {
    private JButton applyButton;
    private JTree configTree;
    private JScrollPane configTreeScrollPane;
    private JButton revertButton;
    private JButton saveButton;
    private JPanel settingsPanel;

    public static void main(String ... args) {
        new Apple2e();
        Apple2e.getComputer().reconfigure();
        Configuration.loadSettings();
        JFrame f = new JFrame();
        f.setContentPane(new ConfigurationPanel());
        f.setSize(f.getContentPane().getPreferredSize());
        f.validate();
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    public ConfigurationPanel() {
        this.initComponents();
        this.expandAll(this.configTree);
    }

    private void initComponents() {
        this.configTreeScrollPane = new JScrollPane();
        this.configTree = new JTree();
        this.settingsPanel = new JPanel();
        this.applyButton = new JButton();
        this.saveButton = new JButton();
        this.revertButton = new JButton();
        this.setPreferredSize(new Dimension(600, 375));
        this.configTree.setModel(new Configuration.ConfigTreeModel());
        this.configTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                ConfigurationPanel.this.configTreeValueChanged(evt);
            }
        });
        this.configTreeScrollPane.setViewportView(this.configTree);
        this.settingsPanel.setAlignmentX(0.0f);
        this.settingsPanel.setAlignmentY(0.0f);
        this.settingsPanel.setLayout(new GridBagLayout());
        this.applyButton.setText("Apply");
        this.applyButton.setToolTipText("Apply current changes without saving");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.applyButtonActionPerformed(evt);
            }
        });
        this.saveButton.setText("Save");
        this.saveButton.setToolTipText("Apply settings and save");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.saveButtonActionPerformed(evt);
            }
        });
        this.revertButton.setText("Revert");
        this.revertButton.setToolTipText("Revert all settings to last saved values (hold SHIFT while clicking to revert to defaults)");
        this.revertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.revertButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.applyButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.revertButton)).addComponent(this.configTreeScrollPane, -2, 286, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.settingsPanel, -1, 308, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.configTreeScrollPane, -1, 327, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.applyButton).addComponent(this.saveButton).addComponent(this.revertButton)).addContainerGap()).addComponent(this.settingsPanel, -1, 375, Short.MAX_VALUE));
    }

    private void configTreeValueChanged(TreeSelectionEvent evt) {
        this.settingsPanel.removeAll();
        Configuration.ConfigNode node = (Configuration.ConfigNode)evt.getPath().getLastPathComponent();
        if (node != null && node.subject != null && !node.getAllSettingNames().isEmpty()) {
            GridBagLayout l = (GridBagLayout)this.settingsPanel.getLayout();
            GridBagConstraints c = new GridBagConstraints();
            int y = 0;
            for (String s : node.getAllSettingNames()) {
                try {
                    Field f = node.subject.getClass().getField(s);
                    ConfigurableField annotation = f.getAnnotation(ConfigurableField.class);
                    if (annotation == null) continue;
                    JLabel label = new JLabel(annotation.name());
                    c.anchor = 23;
                    c.fill = 2;
                    c.gridwidth = 1;
                    c.gridy = y++;
                    c.gridx = 0;
                    c.weightx = 0.0;
                    c.insets = new Insets(2, 2, 2, 2);
                    c.ipady = 2;
                    this.settingsPanel.add((Component)label, c);
                    Component edit = this.generateEditComponent(node, s);
                    edit.setSize(edit.getPreferredSize());
                    c.gridx = 1;
                    c.weightx = 0.5;
                    c.ipady = 0;
                    c.insets = new Insets(0, 2, 2, 2);
                    c.gridwidth = 0;
                    this.settingsPanel.add(edit, c);
                    if (annotation.description().equals("")) continue;
                    c.gridy = y++;
                    c.gridx = 0;
                    c.gridwidth = 2;
                    c.weightx = 0.0;
                    JLabel desc = new JLabel("<html><i>" + annotation.description());
                    c.insets = new Insets(1, 15, 7, 5);
                    this.settingsPanel.add((Component)desc, c);
                }
                catch (NoSuchFieldException ex) {
                    Logger.getLogger(ConfigurationPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (SecurityException ex) {
                    Logger.getLogger(ConfigurationPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        this.settingsPanel.validate();
        this.settingsPanel.setVisible(true);
        this.settingsPanel.repaint();
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        Configuration.applySettings(Configuration.BASE);
        this.configTree.updateUI();
        this.expandAll(this.configTree);
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        Configuration.saveSettings();
        this.configTree.updateUI();
        this.expandAll(this.configTree);
    }

    private void revertButtonActionPerformed(ActionEvent evt) {
        if ((evt.getModifiers() & 1) != 0) {
            this.revertDefaultsActionPerformed(evt);
            return;
        }
        Configuration.loadSettings();
        this.configTree.updateUI();
        this.expandAll(this.configTree);
    }

    private void revertDefaultsActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(null, "Revert all settings to defaults?", "Revert to defaults?", 0) != 0) {
            return;
        }
        Configuration.resetToDefaults();
    }

    public void expandAll(JTree tree) {
        int row = 0;
        while (row < tree.getRowCount()) {
            tree.expandRow(row++);
        }
    }

    private Component generateEditComponent(Configuration.ConfigNode node, String s) {
        try {
            Field f = node.subject.getClass().getField(s);
            if (f.getType().isPrimitive()) {
                if (f.getType().equals(Boolean.TYPE)) {
                    return new BooleanComponent(node, s);
                }
                if (f.getType().equals(Integer.TYPE)) {
                    return new IntegerComponent(node, s);
                }
                if (f.getType().equals(Short.TYPE)) {
                    return new IntegerComponent(node, s);
                }
                if (f.getType().equals(Byte.TYPE)) {
                    return new IntegerComponent(node, s);
                }
                if (f.getType().equals(Long.TYPE)) {
                    return new IntegerComponent(node, s);
                }
                return new StringComponent(node, s);
            }
            if (f.getType().equals(String.class)) {
                return new StringComponent(node, s);
            }
            if (f.getType().equals(File.class)) {
                return new FileComponent(node, s);
            }
            if (!Class.class.isEnum() && ISelection.class.isAssignableFrom(f.getType())) {
                return new DynamicSelectComponent(node, s);
            }
            return new JTextField();
        }
        catch (NoSuchFieldException ex) {
            Logger.getLogger(ConfigurationPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(ConfigurationPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }
}

